%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkGraphics_typemaps.i


%{
#include "vtkProjectedTexture.h"
%}

%import vtkDataSetToDataSetFilter.h


%{
extern void vtkProjectedTexture_freefunc(void *ptr)
{
    vtkProjectedTexture *obj;
    obj = (vtkProjectedTexture*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetPosition()
}
%ignore GetPosition(double data[3]);
%ignore GetPosition(double _arg[3]);
%ignore GetPosition(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetFocalPoint()
}
%ignore GetFocalPoint(double data[3]);
%ignore GetFocalPoint(double _arg[3]);
%ignore GetFocalPoint(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetOrientation()
}
%ignore GetOrientation(double data[3]);
%ignore GetOrientation(double _arg[3]);
%ignore GetOrientation(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetUp()
}
%ignore GetUp(double data[3]);
%ignore GetUp(double _arg[3]);
%ignore GetUp(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetAspectRatio()
}
%ignore GetAspectRatio(double data[3]);
%ignore GetAspectRatio(double _arg[3]);
%ignore GetAspectRatio(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[2]{
   double *GetSRange()
}
%ignore GetSRange(double data[2]);
%ignore GetSRange(double _arg[2]);
%ignore GetSRange(double &_arg1,double &_arg2);

%typemap(ruby,out) double value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[2]{
   double *GetTRange()
}
%ignore GetTRange(double data[2]);
%ignore GetTRange(double _arg[2]);
%ignore GetTRange(double &_arg1,double &_arg2);

%include vtkProjectedTexture.h
