%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkImaging_typemaps.i


%{
#include "vtkImageImport.h"
%}

%import vtkImageSource.h


%{
extern void vtkImageImport_freefunc(void *ptr)
{
    vtkImageImport *obj;
    obj = (vtkImageImport*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetDataExtent()
}
%ignore GetDataExtent(int data[6]);
%ignore GetDataExtent(int _arg[6]);
%ignore GetDataExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetDataSpacing()
}
%ignore GetDataSpacing(float data[3]);
%ignore GetDataSpacing(float _arg[3]);
%ignore GetDataSpacing(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetDataOrigin()
}
%ignore GetDataOrigin(float data[3]);
%ignore GetDataOrigin(float _arg[3]);
%ignore GetDataOrigin(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetWholeExtent()
}
%ignore GetWholeExtent(int data[6]);
%ignore GetWholeExtent(int _arg[6]);
%ignore GetWholeExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%include vtkImageImport.h
