%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkGraphics_typemaps.i


%{
#include "vtkDataObjectToDataSetFilter.h"
%}

%import vtkSource.h


%{
extern void vtkDataObjectToDataSetFilter_freefunc(void *ptr)
{
    vtkDataObjectToDataSetFilter *obj;
    obj = (vtkDataObjectToDataSetFilter*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetDimensions()
}
%ignore GetDimensions(int data[3]);
%ignore GetDimensions(int _arg[3]);
%ignore GetDimensions(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetOrigin()
}
%ignore GetOrigin(float data[3]);
%ignore GetOrigin(float _arg[3]);
%ignore GetOrigin(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetSpacing()
}
%ignore GetSpacing(float data[3]);
%ignore GetSpacing(float _arg[3]);
%ignore GetSpacing(float &_arg1,float &_arg2,float &_arg3);

%include vtkDataObjectToDataSetFilter.h
