#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include "ruby.h"

#if GTK_MAJOR_VERSION == 1
#define RVAL2GTKWIDGET(obj)  (get_widget(obj))
#define RVAL2GDKPIXMAP(obj)  (get_gdkpixmap(obj))


static GtkObject*
get_gobject(obj)
    VALUE obj;
{
    struct RData *data;
    GtkObject *gtkp;

    if (NIL_P(obj)) { 
        rb_raise(rb_eTypeError, "wrong argument type nil");
    }

    Check_Type(obj, T_OBJECT);
    data = RDATA(rb_ivar_get(obj, rb_intern("gtkdata")));
    if (NIL_P(data)) {
        rb_raise(rb_eTypeError, "not a Gtk object");
    }
    Data_Get_Struct(data, GtkObject, gtkp);
    if (!gtkp) {
        rb_raise(rb_eArgError, "destroyed GtkObject");
    }
    if (!GTK_IS_OBJECT(gtkp)) {
        rb_raise(rb_eTypeError, "not a GtkObject");
    }

    return gtkp;
}

static GtkWidget*
get_widget(obj)
    VALUE obj;
{
    GtkObject *data = get_gobject(obj);

    return GTK_WIDGET(data);
}

static GdkPixmap*
get_gdkpixmap(obj)
    VALUE obj;
{
    GdkPixmap *pixmap;

    Data_Get_Struct(obj, GdkPixmap, pixmap);

    return pixmap;
}


#elif GTK_MAJOR_VERSION == 2
#define CLASS2GTYPE(klass) (rbgobj_lookup_class(klass)->gtype)
#define RVAL2GOBJ(obj)  (rbgobj_instance_from_ruby_object(obj))
#define RVAL2GTYPE(obj)    (CLASS2GTYPE(CLASS_OF(obj)))
#define RVAL2GTKWIDGET(obj)  ((GtkWidget*)RVAL2GOBJ(obj))
#define RVAL2GDKPIXMAP(obj)  ((GdkPixmap*)RVAL2GOBJ(obj))
#endif


static VALUE
dcl_zgsdrw(self, drawable)
     VALUE self, drawable;
{
  extern zgsdrw_(GtkWidget*);

  zgsdrw_( RVAL2GTKWIDGET(drawable) );

  return Qnil;

}

static VALUE
dcl_zgspmp(self, pixmap)
     VALUE self, pixmap;
{
  extern zgspmp_(GdkPixmap*);

  zgspmp_( RVAL2GDKPIXMAP(pixmap) );

  return Qnil;

}

static VALUE
r_gtk_version(self)
     VALUE self;
{
  return rb_ary_new3(3,
		     INT2NUM(gtk_major_version),
		     INT2NUM(gtk_minor_version),
		     INT2NUM(gtk_micro_version));
}


void
init_grph1_zgpack(mDCL)
VALUE mDCL;
{

  rb_define_module_function(mDCL, "gtk_version", r_gtk_version, 0);

  rb_define_module_function(mDCL, "zgsdrw", dcl_zgsdrw, 1);
  rb_define_module_function(mDCL, "zgspmp", dcl_zgspmp, 1);

}

