/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


VALUE mDCL;

static VALUE
dcl_slinit(obj, wxmax, wymax, fact)
    VALUE obj, wxmax, wymax, fact;
{
    real i_wxmax;
    real i_wymax;
    real i_fact;

    if (TYPE(wxmax) != T_FLOAT) {
      wxmax = rb_funcall(wxmax, rb_intern("to_f"), 0);
    }
    if (TYPE(wymax) != T_FLOAT) {
      wymax = rb_funcall(wymax, rb_intern("to_f"), 0);
    }
    if (TYPE(fact) != T_FLOAT) {
      fact = rb_funcall(fact, rb_intern("to_f"), 0);
    }

    i_wxmax = (real)NUM2DBL(wxmax);
    i_wymax = (real)NUM2DBL(wymax);
    i_fact = (real)NUM2DBL(fact);


    slinit_(&i_wxmax, &i_wymax, &i_fact);

    return Qnil;

}

static VALUE
dcl_slsize(obj, cszez)
    VALUE obj, cszez;
{
    char *i_cszez;

    if (TYPE(cszez) != T_STRING) {
      cszez = rb_funcall(cszez, rb_intern("to_str"), 0);
    }

    i_cszez = STR2CSTR(cszez);


    slsize_(i_cszez, (ftnlen)strlen(i_cszez));

    return Qnil;

}

static VALUE
dcl_slform(obj, dxa, dya)
    VALUE obj, dxa, dya;
{
    real i_dxa;
    real i_dya;

    if (TYPE(dxa) != T_FLOAT) {
      dxa = rb_funcall(dxa, rb_intern("to_f"), 0);
    }
    if (TYPE(dya) != T_FLOAT) {
      dya = rb_funcall(dya, rb_intern("to_f"), 0);
    }

    i_dxa = (real)NUM2DBL(dxa);
    i_dya = (real)NUM2DBL(dya);


    slform_(&i_dxa, &i_dya);

    return Qnil;

}

static VALUE
dcl_sldiv(obj, cform, ix, iy)
    VALUE obj, cform, ix, iy;
{
    char *i_cform;
    integer i_ix;
    integer i_iy;

    if (TYPE(cform) != T_STRING) {
      cform = rb_funcall(cform, rb_intern("to_str"), 0);
    }
    if ((TYPE(ix) != T_BIGNUM) || (TYPE(ix) != T_FIXNUM)) {
      ix = rb_funcall(ix, rb_intern("to_i"), 0);
    }
    if ((TYPE(iy) != T_BIGNUM) || (TYPE(iy) != T_FIXNUM)) {
      iy = rb_funcall(iy, rb_intern("to_i"), 0);
    }

    i_cform = STR2CSTR(cform);
    i_ix = NUM2INT(ix);
    i_iy = NUM2INT(iy);


    sldiv_(i_cform, &i_ix, &i_iy, (ftnlen)strlen(i_cform));

    return Qnil;

}

static VALUE
dcl_slmgn(obj, xl, xr, yb, yt)
    VALUE obj, xl, xr, yb, yt;
{
    real i_xl;
    real i_xr;
    real i_yb;
    real i_yt;

    if (TYPE(xl) != T_FLOAT) {
      xl = rb_funcall(xl, rb_intern("to_f"), 0);
    }
    if (TYPE(xr) != T_FLOAT) {
      xr = rb_funcall(xr, rb_intern("to_f"), 0);
    }
    if (TYPE(yb) != T_FLOAT) {
      yb = rb_funcall(yb, rb_intern("to_f"), 0);
    }
    if (TYPE(yt) != T_FLOAT) {
      yt = rb_funcall(yt, rb_intern("to_f"), 0);
    }

    i_xl = (real)NUM2DBL(xl);
    i_xr = (real)NUM2DBL(xr);
    i_yb = (real)NUM2DBL(yb);
    i_yt = (real)NUM2DBL(yt);


    slmgn_(&i_xl, &i_xr, &i_yb, &i_yt);

    return Qnil;

}

static VALUE
dcl_slrat(obj, rx, ry)
    VALUE obj, rx, ry;
{
    real i_rx;
    real i_ry;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }
    if (TYPE(ry) != T_FLOAT) {
      ry = rb_funcall(ry, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);
    i_ry = (real)NUM2DBL(ry);


    slrat_(&i_rx, &i_ry);

    return Qnil;

}

static VALUE
dcl_slsttl(obj, cttl, cside, px, py, ht, nt)
    VALUE obj, cttl, cside, px, py, ht, nt;
{
    char *i_cttl;
    char *i_cside;
    real i_px;
    real i_py;
    real i_ht;
    integer i_nt;

    if (TYPE(cttl) != T_STRING) {
      cttl = rb_funcall(cttl, rb_intern("to_str"), 0);
    }
    if (TYPE(cside) != T_STRING) {
      cside = rb_funcall(cside, rb_intern("to_str"), 0);
    }
    if (TYPE(px) != T_FLOAT) {
      px = rb_funcall(px, rb_intern("to_f"), 0);
    }
    if (TYPE(py) != T_FLOAT) {
      py = rb_funcall(py, rb_intern("to_f"), 0);
    }
    if (TYPE(ht) != T_FLOAT) {
      ht = rb_funcall(ht, rb_intern("to_f"), 0);
    }
    if ((TYPE(nt) != T_BIGNUM) || (TYPE(nt) != T_FIXNUM)) {
      nt = rb_funcall(nt, rb_intern("to_i"), 0);
    }

    i_cttl = STR2CSTR(cttl);
    i_cside = STR2CSTR(cside);
    i_px = (real)NUM2DBL(px);
    i_py = (real)NUM2DBL(py);
    i_ht = (real)NUM2DBL(ht);
    i_nt = NUM2INT(nt);


    slsttl_(i_cttl, i_cside, &i_px, &i_py, &i_ht, &i_nt, (ftnlen)strlen(i_cttl), (ftnlen)strlen(i_cside));

    return Qnil;

}

static VALUE
dcl_sldttl(obj, nt)
    VALUE obj, nt;
{
    integer i_nt;

    if ((TYPE(nt) != T_BIGNUM) || (TYPE(nt) != T_FIXNUM)) {
      nt = rb_funcall(nt, rb_intern("to_i"), 0);
    }

    i_nt = NUM2INT(nt);


    sldttl_(&i_nt);

    return Qnil;

}

static VALUE
dcl_slpvpr(obj, index)
    VALUE obj, index;
{
    integer i_index;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_index = NUM2INT(index);


    slpvpr_(&i_index);

    return Qnil;

}

static VALUE
dcl_slpwwr(obj, index)
    VALUE obj, index;
{
    integer i_index;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_index = NUM2INT(index);


    slpwwr_(&i_index);

    return Qnil;

}

static VALUE
dcl_slpwvr(obj, index)
    VALUE obj, index;
{
    integer i_index;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_index = NUM2INT(index);


    slpwvr_(&i_index);

    return Qnil;

}

static VALUE
dcl_slpvpc(obj, index, rc)
    VALUE obj, index, rc;
{
    integer i_index;
    real i_rc;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rc) != T_FLOAT) {
      rc = rb_funcall(rc, rb_intern("to_f"), 0);
    }

    i_index = NUM2INT(index);
    i_rc = (real)NUM2DBL(rc);


    slpvpc_(&i_index, &i_rc);

    return Qnil;

}

static VALUE
dcl_slpwwc(obj, index, rc)
    VALUE obj, index, rc;
{
    integer i_index;
    real i_rc;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rc) != T_FLOAT) {
      rc = rb_funcall(rc, rb_intern("to_f"), 0);
    }

    i_index = NUM2INT(index);
    i_rc = (real)NUM2DBL(rc);


    slpwwc_(&i_index, &i_rc);

    return Qnil;

}

static VALUE
dcl_slpwvc(obj, index, rc)
    VALUE obj, index, rc;
{
    integer i_index;
    real i_rc;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rc) != T_FLOAT) {
      rc = rb_funcall(rc, rb_intern("to_f"), 0);
    }

    i_index = NUM2INT(index);
    i_rc = (real)NUM2DBL(rc);


    slpwvc_(&i_index, &i_rc);

    return Qnil;

}
void
init_grph1_slpack(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "slinit", dcl_slinit, 3);
    rb_define_module_function(mDCL, "slsize", dcl_slsize, 1);
    rb_define_module_function(mDCL, "slform", dcl_slform, 2);
    rb_define_module_function(mDCL, "sldiv", dcl_sldiv, 3);
    rb_define_module_function(mDCL, "slmgn", dcl_slmgn, 4);
    rb_define_module_function(mDCL, "slrat", dcl_slrat, 2);
    rb_define_module_function(mDCL, "slsttl", dcl_slsttl, 6);
    rb_define_module_function(mDCL, "sldttl", dcl_sldttl, 1);
    rb_define_module_function(mDCL, "slpvpr", dcl_slpvpr, 1);
    rb_define_module_function(mDCL, "slpwwr", dcl_slpwwr, 1);
    rb_define_module_function(mDCL, "slpwvr", dcl_slpwvr, 1);
    rb_define_module_function(mDCL, "slpvpc", dcl_slpvpc, 2);
    rb_define_module_function(mDCL, "slpwwc", dcl_slpwwc, 2);
    rb_define_module_function(mDCL, "slpwvc", dcl_slpwvc, 2);
}
