/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_rprd(obj, rx, ry, n, jx, jy)
    VALUE obj, rx, ry, n, jx, jy;
{
    real *i_rx;
    real *i_ry;
    integer i_n;
    integer i_jx;
    integer i_jy;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(ry) == T_FLOAT) {
      ry = rb_Array(ry);
    }
    /* if ((TYPE(ry) != T_ARRAY) && 
           (rb_obj_is_kind_of(ry, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }
    if ((TYPE(jy) != T_BIGNUM) || (TYPE(jy) != T_FIXNUM)) {
      jy = rb_funcall(jy, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_jy = NUM2INT(jy);
    i_rx = dcl_obj2crealary(rx);
    i_ry = dcl_obj2crealary(ry);


    o_rtn_val = rprd_(i_rx, i_ry, &i_n, &i_jx, &i_jy);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecrealary(i_ry);

    return rtn_val;

}

static VALUE
dcl_rcov(obj, rx, ry, n, jx, jy)
    VALUE obj, rx, ry, n, jx, jy;
{
    real *i_rx;
    real *i_ry;
    integer i_n;
    integer i_jx;
    integer i_jy;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(ry) == T_FLOAT) {
      ry = rb_Array(ry);
    }
    /* if ((TYPE(ry) != T_ARRAY) && 
           (rb_obj_is_kind_of(ry, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }
    if ((TYPE(jy) != T_BIGNUM) || (TYPE(jy) != T_FIXNUM)) {
      jy = rb_funcall(jy, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_jy = NUM2INT(jy);
    i_rx = dcl_obj2crealary(rx);
    i_ry = dcl_obj2crealary(ry);


    o_rtn_val = rcov_(i_rx, i_ry, &i_n, &i_jx, &i_jy);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecrealary(i_ry);

    return rtn_val;

}

static VALUE
dcl_rcor(obj, rx, ry, n, jx, jy)
    VALUE obj, rx, ry, n, jx, jy;
{
    real *i_rx;
    real *i_ry;
    integer i_n;
    integer i_jx;
    integer i_jy;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(ry) == T_FLOAT) {
      ry = rb_Array(ry);
    }
    /* if ((TYPE(ry) != T_ARRAY) && 
           (rb_obj_is_kind_of(ry, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }
    if ((TYPE(jy) != T_BIGNUM) || (TYPE(jy) != T_FIXNUM)) {
      jy = rb_funcall(jy, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    i_jy = NUM2INT(jy);
    i_rx = dcl_obj2crealary(rx);
    i_ry = dcl_obj2crealary(ry);


    o_rtn_val = rcor_(i_rx, i_ry, &i_n, &i_jx, &i_jy);

    rtn_val = rb_float_new((double)o_rtn_val);

    dcl_freecrealary(i_rx);
    dcl_freecrealary(i_ry);

    return rtn_val;

}
void
init_math1_rfblib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "rprd", dcl_rprd, 5);
    rb_define_module_function(mDCL, "rcov", dcl_rcov, 5);
    rb_define_module_function(mDCL, "rcor", dcl_rcor, 5);
}
