#
# kihon5.rb
#   $Id: kihon5.rb,v 1.2 2000/11/18 19:03:32 keiko Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nmax = 40
imax = 4

x = NArray.sfloat(nmax+1, imax)
y = NArray.sfloat(nmax+1, imax)
xc = NArray[0.25, 0.75, 0.25, 0.75]
yc = NArray[0.75, 0.75, 0.25, 0.25]

#-- data ----
dt = 2*PI/6
for n in 0..5
  for i in 0..imax-2
    x[n,i] = 0.2*cos(n*dt) + xc[i]  
    y[n,i] = 0.2*sin(n*dt) + yc[i]  
  end
end

dt = 4*PI/nmax
for n in 0..nmax
  x[n,imax-1] = 0.4*n/nmax - 0.2 + xc[imax-1]
  y[n,imax-1] = 0.2*sin(n*dt) + yc[imax-1]
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

DCL::sglset('LSOFTF', true)
DCL::sgfrm

#-- default ----
DCL::sgtnv(x[0..5,0], y[0..5,0])

#-- tone pattern ----
DCL::sgstnp(3)
DCL::sgtnv(x[0..5,1], y[0..5,1])

DCL::sgstnp(601)
DCL::sgtnv(x[0..5,2], y[0..5,2])

#-- twisted polygon ----
DCL::sgtnv(x[true,3], y[true,3])

DCL::sgcls

