=begin
= Permutations

== Class methods

--- GSL::Permutation.new(n)
--- GSL::Permutation.alloc(n)
    These functions create a new permutation of size ((|n|)). 
    The permutation is not initialized and its elements are undefined. 
    Use (({GSL::Permutation.calloc})) if you want to create a permutation 
    which is initialized to the identity. 

--- GSL::Permutation.calloc(n)
    This creates a new permutation of size ((|n|)) and initializes it to the identity. 

== Methods
--- GSL::Permutation#init()
    This initializes the permutation to the identity, i.e. (0,1,2,...,n-1). 

--- GSL::Permutation.memcpy(dest, src)
    This method copies the elements of the permutation ((|src|)) 
    into the permutation ((|dest|)). The two permutations must have the same size.

--- GSL::Permutation#clone
    This creates a new permutation with the same elements of ((|self|)).

=== Accessing permutation elements

--- GSL::Permutation#get(i)
    Returns the value of the ((|i|))-th element of the permutation. 

--- GSL::Permutation#swap(i, j)
    This exchanges the ((|i|))-th and ((|j|))-th elements of the permutation.

=== Permutation properties
--- GSL::Permutation#size
    Returns the size of the permutation.
--- GSL::Permutation#valid
    This checks that the permutation ((|self|)) is valid. 
    The n elements should contain each of the numbers 0 .. n-1 once and only once.

--- GSL::Permutation#valid?
    This returns true if the permutation ((|self|)) is valid, and false otherwise.

=== Permutation functions

--- GSL::Permutation#reverse
    This reverses the elements of the permutation ((|self|)).
--- GSL::Permutation#inverse
    This computes the inverse of the permutation ((|self|)), and returns
    as a new permutation.

--- GSL::Permutation#next
    This method advances the permutation ((|self|)) to the next permutation in 
    lexicographic order and returns (({GSL::SUCCESS})). If no further permutations 
    are available it returns (({GSL::FAILURE})) and leaves ((|self|)) unmodified. 
    Starting with the identity permutation and repeatedly applying this function 
    will iterate through all possible permutations of a given order.
--- GSL::Permutation#prev
    This method steps backwards from the permutation ((|self|)) to the previous 
    permutation in lexicographic order, returning (({GSL_SUCCESS})). 
    If no previous permutation is available it returns (({GSL_FAILURE})) 
    and leaves ((|self|)) unmodified.

=== Reading and writing permutations
--- GSL::Permutation#fwrite(io)
--- GSL::Permutation#fwrite(filename)
--- GSL::Permutation#fread(io)
--- GSL::Permutation#fread(filename)
--- GSL::Permutation#fprintf(io, format = "%u\n")
--- GSL::Permutation#fprintf(filename, format = "%u\n")
--- GSL::Permutation#fscanf(io)
--- GSL::Permutation#fscanf(filename)

=== Permutations in Cyclic Form
--- GSL::Permutation#linear_to_canonical
--- GSL::Permutation#to_canonical
--- GSL::Permutation#canonical_to_linear
--- GSL::Permutation#to_linear
--- GSL::Permutation#inversions
--- GSL::Permutation#linear_cycles
--- GSL::Permutation#canonical_cycles

((<prev|URL:matrix.html>))
((<next|URL:combi.html>))

((<Reference index|URL:ref.html>))
((<top|URL:index.html>))

=end
