#!/usr/bin/env ruby
require("gsl")
include MultiFit

N = 100

y0 = 0.1
A = 2
rr = -1.5

r = Rng.new()
x = Vector.linspace(0.1, 1, N)
y =  y0 + A*pow(x, rr) + 0.1*r.gaussian(1, N)

coef, err, chi2, dof = MultiFit::FdfSolver.fit(x, y, "power")
y0 = coef[0]
amp = coef[1]
rr = coef[2]
p coef
p err

graph(x, y, y0+amp*pow(x, rr), "-T X -C -g 3 -l x -l y")
