#!/usr/bin/env ruby
require("gsl")

n = 630
data = FFT::Complex::PackedArray.new(2*n)

table = FFT::Complex::Wavetable.new(n)
space = FFT::Complex::Workspace.new(n)

data.set_real(0, 1.0)
for i in 1..10 do
  data[i] = [1.0, 0.0]
  data[n-i] = [1.0, 0.0]
end

# Select whichever you like
#ffted = data.forward(1, n, table, space)
#ffted = data.forward(n, table, space)
#ffted = data.forward(table, space)
#ffted = data.forward(n, table)
#ffted = data.forward(n, space)
#ffted = data.forward(n)
#ffted = data.forward(table)
#ffted = data.forward(space)
#ffted = data.forward()
#ffted = data.transform(table, space, FFT::Forward)
#ffted = data.transform(FFT::Forward)
#ffted = FFT::Complex.forward(data, table, space)
ffted = FFT::Complex.forward(data)
#ffted = FFT::Complex.transform(data, table, space, FFT::Forward)
#ffted = FFT::Complex.transform(data, FFT::Forward)
ffted /= Math::sqrt(n)
graph(nil, data.re, ffted.re, "-C -g 3")
