 
// -*- C++ -*-

// (c) COPYRIGHT OPeNDAP 2005
// Please read the full copyright statement in the file COPYING
//
// Authors:
//      jimg,jhrg	James Gallagher <jgallagher@opendap.org>

#ifndef dim_proj_info_h
#define dim_proj_info_h 1

/** Command Line Dimension Projection. This struct holds the projection
    information for one dimension, as given on the command line. A vector of
    these objects are used to hold the CE passed to the Client Library on the
    command line. They are read and used when building CEs for URLs that get
    data. We cannot store this information in the Array class' existing
    fields (at least not w/o hacking the DAP library) because it's likely the
    indeces exceed the limits of the variable. How? Because the CL asks for a
    Constrained DDS using the CE so an array constrained by [2:5] will look
    like one that holds only four elements and an index of 5 causes
    Array::add_constraint() to throw an exception. So, the information is
    stored here. Look in build_constraint() to see how it is used. */
struct dim_proj_info {
    int start;
    int stop;
    int stride;
    
    dim_proj_info() : start(0), stop(0), stride(0) {}
    dim_proj_info(string clause) {
        // Extract the indices and store the values.
        // First, replace syntax with spaces...
        string::size_type separator = 0;
        // separator = clause.find_first_of("[]:", separator);
        while ((separator = clause.find_first_of("[]:", separator))
	       != string::npos) {
            clause.replace(separator, 1, " ");
        }
        // now read numbers after name.
        istringstream iss(clause.c_str());
        // string dummy;
        int i1, i2, i3;
        // iss >> dummy;
        if (iss >> i1) {
            if (iss >> i2) {
                if (iss >> i3) {
                    // Found start, stride, stop
                    start = i1;
                    stride = i2;
                    stop = i3;
                    return;
                }
                // Found start, stop but no stride
                start = i1;
                stride = 1;
                stop = i2;
                return;
            }
            // Found start but no stride or stop
            start = i1;
            stop = i1;
            stride = 1;
            return;
        }
    }
};
    
// $Log: DimProjInfo.h,v $
// Revision 1.2  2005/04/14 20:48:05  jimg
// Comments, log.
//

#endif // dim_proj_info_h
