=begin
=gpcommon.rb

 This library provides common methods used in gp* command. 

==METHOD LIST

  * help                           : print help message

  * NumRu::Netcdf.copy_global_att  : Copy global attributes from a Gphys 
                                     variable. It operates only when a gphys 
                                     variable consistof a NetCDF file.

==HISTORY

  2005/08/23  S Takehiro (created)

=end

#------------------------ print help message ------------------------
def help
  file = File.open($0)
  after_begin = false
  after_end = false
  while (line = file.gets)
    after_end = true if /^=end/ =~ line
    print line if after_begin && !after_end
    after_begin = true if /^=begin/ =~ line
  end
  file.close
end

#------------- Copy global attributes (only for NetCDF file) --------
class NumRu::NetCDF
  def copy_global_att(gp)
    ncfile = gp.data.file 
    if /NetCDF/  =~ ncfile.class.to_s
      ncfile.each_att{|att|
        att.copy(self)
      }
    end
  end
end
