=begin header
  draw.rb - a part of gave.rb
=end

require "numru/gphys"


module NumRu
  class VArray
    def mapping
      @mapping
    end
  end
  class SubsetMapping
    def maps
      @maps
    end
  end
  class VArrayComposite
    alias _initialize initialize
    alias :_slice []
    def initialize(*arg)
      _initialize(*arg)
      @mapping2 = SubsetMapping.new(shape_current,[])
    end
    def [](*arg)
      mapping = @mapping2.composite(SubsetMapping.new(shape_current, arg))
      obj = self._slice(*arg)
      obj.set_mapping(mapping) if obj.class==VArrayComposite
      obj
    end
    def mapping
      @mapping2
    end
    def set_mapping(map)
      @mapping2 = map
    end
  end
end


include NumRu


class Draw_data
  attr_accessor :gphys, :gphys2
  attr_accessor :cont, :cont_i
  attr_accessor :tone, :tone_i
  attr_accessor :vector
  attr_accessor :transpose
  attr_accessor :type, :map_type, :map_draw, :map_pole
  attr_accessor :title
  attr_accessor :surface
#  attr_accessor :missing_value
  attr_reader :axis_x, :axis_y, :axis_z
  def initialize
    @axis_x = Axis.new
    @axis_y = Axis.new
    @axis_z = Axis.new
    clear
  end
  def clear_var
    @gphys = nil
    @gphys2 = nil
    @transpose = false
    @axis_x.clear
    @axis_y.clear
  end
  def clear
    clear_var
    @title = nil
    @type = LINE
    @map_type = nil
  end
  class Axis
    attr_accessor :min, :max
    attr_accessor :title, :unit
    attr_accessor :log
    def initialize
      clear
    end
    def clear
      @title=""
      @unit=""
      @log=false
    end
  end
end





class Draw
  def initialize(n)
    @winno = n
    @height=400
    @width=400
    clear
  end
  def clear
    @type = nil
#    @miss=nil
    @title = nil
    @x_title=""; @x_unit=""
    @y_title=""; @y_unit=""
    @fig = Fig.new
    @opened = false
  end
  def show
    @window.show if defined?(@window)&&(!@window.nil?)
  end
  def draw_x(draw_data)
    @xmin = draw_data.axis_x.min
    @xmax = draw_data.axis_x.max
    @ymin = draw_data.axis_y.min
    @ymax = draw_data.axis_y.max
    @gphys = draw_data.gphys
    @gphys2 = draw_data.gphys2
    @mapping = draw_data.gphys.data.mapping.slicer
#    @miss = draw_data.missing_value
    @title = draw_data.title
    @transpose = draw_data.transpose
    @logx = draw_data.axis_x.log
    @logy = draw_data.axis_y.log
    @x_title = draw_data.axis_x.title
    @x_unit = draw_data.axis_x.unit
    @y_title = draw_data.axis_y.title
    @y_unit = draw_data.axis_y.unit
    @type = draw_data.type
    @maptype = draw_data.map_type
    @map_draw = draw_data.map_draw
    @map_pole = draw_data.map_pole
    @cont = draw_data.cont
    @cont_i = draw_data.cont_i
    @tone = draw_data.tone
    @tone_i = draw_data.tone_i
    @vector = draw_data.vector
    @surface = draw_data.surface
    @fig.var_set(@gphys.funcs,@mapping,0)
    @fig.var_set(@gphys2.funcs,@mapping,1) if @type == VECTOR
    @fig.title_set(@x_title,@x_unit,@y_title,@y_unit, __FILE__,__LINE__)
    if @window.nil?
      open_graphics
    end
    draw(@draw_area)
    @window.show
  end
  def save_code(filename)
    file = File.open(filename,"w")
    file.print(@fig.head+"\n\n")
    file.print(@fig.var+"\n\n")
    file.print(@fig.open+"\n\n")
    file.print(@fig.draw+"\n\n")
    file.print(@fig.close+"\n\n")
    file.close
  end
  def save_image(filename)
    begin
      save_image_file(filename)
      p "save image to #{filename}"
    rescue
      dialog = Gtk::Dialog.new.set_title("Error Message")
      dialog.set_modal(true)
      dialog.vbox.pack_start(Gtk::Label.new($!))
      ok_button=Gtk::Button.new("OK")
      ok_button.signal_connect("clicked"){dialog.destroy}
      dialog.action_area.pack_start(ok_button)
      dialog.show_all
    end
  end

end
